var base_url = "https://bitpick.co/";
function process_login() {
	var user_email = $('#user_email').val();
	var user_pwd = $('#user_pwd').val();
	var user_2fa = $('#user_2fa').val();
	$.ajax({
		url: base_url+"api.php",
		type: "POST",
		data: "act=process_login&user_email="+user_email+"&user_pwd="+user_pwd+"&user_2fa="+user_2fa,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				if(obj.mes == 'Enter 2fa-code to continue!') {
					window.location.replace(base_url+'login2.php');
				} else {
					swal("Success!", obj.mes, "success");
					setTimeout(function(){
						window.location.replace(base_url);
					}, 1000);
				}
			}
		}
	});
}

function process_continue_login() {
	var  user_2fa = $('#user_2fa').val();
	$.ajax({
		url: base_url+"api.php",
		type: "POST",
		data: "act=process_continue_login&user_2fa="+user_2fa,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				swal("Success!", obj.mes, "success");
				setTimeout(function(){
					window.location.replace(base_url);
				}, 1000);
			}
		}
	});
}

function process_signup() {
	var user_email = $('#user_email').val();
	var user_pwd = $('#user_pwd').val();
	var user_ref = $('#user_ref').val();
	var user_capt = $('#user_capt').val();
	$.ajax({
		url: base_url+"api.php",
		type: "POST",
		data: "act=process_signup&user_email="+user_email+"&user_pwd="+user_pwd+"&user_ref="+user_ref+"&user_capt="+user_capt,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				swal("Success!", obj.mes, "success");
				setTimeout(function(){
					window.location.replace(base_url);
				}, 1000);
			}
		}
	});
}

function process_recover() {
	if($('#continue_recover_button').attr('disabled') == "disabled") {
		return;
	}
	var user_email = $('#recover_email').val();
	var user_capt = $('#recover_captcha').val();
	$("#continue_recover_button").attr("disabled", true);
	$("#continue_recover_button").html("Please wait...");
	$.ajax({
		url: base_url+"api.php",
		type: "POST",
		data: "act=process_recover_password&recover_email="+user_email+"&recover_captcha="+user_capt,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				swal("Success!", obj.mes, "success");
			}
			$("#continue_recover_button").html("Continue");
			$("#continue_recover_button").attr("disabled", false);
		}
	});
}

function process_change_password() {
	if($('#create_new_pwd_button').attr('disabled') == "disabled") {
		return;
	}
	$("#create_new_pwd_button").attr("disabled", true);
	$("#create_new_pwd_button").html("Please wait...");
	var ver_code = $('#ver_code').val();
	var user_id = $('#user_id').val();
	var new_password = $('#new_password').val();
	var rpt_password = $('#rpt_password').val();
	$.ajax({
		url: base_url+"api.php",
		type: "POST",
		data: "act=process_change_password&ver_code="+ver_code+"&user_id="+user_id+"&new_password="+new_password+"&rpt_password="+rpt_password,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				swal("Success!", obj.mes, "success");
				setTimeout(function(){
					window.location.replace(base_url);
				}, 1000);
			}
			$("#create_new_pwd_button").html("Change password");
			$("#create_new_pwd_button").attr("disabled", false);
		}
	});
}

function process_verify_email() {
	var ver_code = $('#ver_code').val();
	var user_id = $('#user_id').val();
	$.ajax({
		url: base_url+"api.php",
		type: "POST",
		data: "act=process_verify_email&ver_code="+ver_code+"&user_id="+user_id,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				swal("Success!", obj.mes, "success");
				setTimeout(function(){
					window.location.replace(base_url);
				}, 1000);
			}
		}
	});
}

function process_confirm_withdrawal() {
	var ver_code = $('#ver_code').val();
	var user_id = $('#user_id').val();
	$.ajax({
		url: base_url+"api.php",
		type: "POST",
		data: "act=process_confirm_withdrawal&ver_code="+ver_code+"&user_id="+user_id,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				swal("Success!", obj.mes, "success");
				setTimeout(function(){
					window.location.replace(base_url+'withdraw.php');
				}, 1000);
			}
		}
	});
}

function process_cancel_withdrawal() {
	var ver_code = $('#ver_code').val();
	var user_id = $('#user_id').val();
	$.ajax({
		url: base_url+"api.php",
		type: "POST",
		data: "act=process_cancel_withdrawal&ver_code="+ver_code+"&user_id="+user_id,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				swal("Success!", obj.mes, "success");
				setTimeout(function(){
					window.location.replace(base_url+'withdraw.php');
				}, 1000);
			}
		}
	});
}

function process_cancel_withdrawal2(request_id) {
	$.ajax({
		url: base_url+"api.php",
		type: "POST",
		data: "act=process_cancel_withdrawal2&request_id="+request_id,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				var current_balance = parseFloat($('.top_balance').text()) * 100000000;
				var amount = parseInt(obj.amount);
				//$('#your_balance').text(parseFloat((current_balance + amount) / 100000000).toFixed(8));
				$('.top_balance').text(parseFloat((current_balance + amount) / 100000000).toFixed(8)+' BTC');
				load_withdrawal_history();
				swal("Success!", obj.mes, "success");
			}
		}
	});
}

function process_roll() {
	if($('#roll_button').attr('disabled') == "disabled") {
		return;
	}
	$('#roll_button').val('Please wait...');
	$("#roll_button").attr("disabled", !0);
	var game_capt = $('#game_capt').val();
	setTimeout(function() {
        $.ajax({
            type: "POST",
            url: base_url+"api.php",
            data: "act=process_roll&game_capt="+game_capt
        }).done(function(json) {
			var obj = JSON.parse(json);
			var get_return = obj.ret;
			var get_message = obj.mes;
			var get_value = obj.val;
			
			if(get_return == 1) {
				setTimeout(function() {
					$("#roll_button").removeAttr("disabled");
					$('#roll_button').val('Claim bitcoins');
					swal("Success!", get_message, "success");
					var current_balance = parseFloat($('.top_balance').text()) * 100000000;
					//$('#your_balance').text(parseFloat((current_balance + get_value * 100000000) / 100000000).toFixed(8));
					$('.top_balance').text(parseFloat((current_balance + get_value * 100000000) / 100000000).toFixed(8)+' BTC');
					$('#show_countdown_clock').show();
					$('#show_free_rolling_game').hide();
					clock = new FlipClock($('.clock'), 3600, {
						clockFace: 'MinuteCounter',
						autoStart: true,
						countdown: true,
						callbacks: {
							stop: function() {
								$('#show_free_rolling_game').show();
								$('#show_countdown_clock').hide();
							}
						}
					});
				}, 1000);
			} else {
				$("#roll_button").removeAttr("disabled");
				$('#roll_button').val('Claim bitcoins');
				swal("Error!", get_message, "error");
			}
        })
    }, 50);
}

function process_dismiss_noti() {
	var id = $(this).attr('notification-id');
	setTimeout(function() {
		$.ajax({
			type: "POST",
			url:  base_url+"api.php",
			data: "act=process_dismiss_noti&noti_id=" + id
		}).done(function(t) {
			
		})
	}, 200);
}

function process_snd_veri_email() {
	if($('.snd_veri_email_button').attr('disabled') == "disabled") {
		return;
	}
	$('.snd_veri_email_button').html('Please wait...');
    $(".snd_veri_email_button").attr("disabled", true);
	$.ajax({
		url:  base_url+"api.php",
		type: "POST",
		data: "act=process_snd_veri_email",
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				swal("Success!", obj.mes, "success");
			}
			$('.snd_veri_email_button').html('Send email');
			$(".snd_veri_email_button").attr("disabled", false);
		},
		timeout: 10000
	});
}

function process_save_withdrawal_adrr() {
	var user_address = $('#user_withdrawal_adrr').val();
	var user_password = $('#user_withdrawal_psw').val();
	$.ajax({
		url:  base_url+"api.php",
		type: "POST",
		data: "act=process_save_withdrawal_adrr&user_address="+user_address+"&user_password="+user_password,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				swal("Success!", obj.mes, "success");
			}
		},
		timeout: 3000
	});
}

function process_save_password() {
	if($('#save_pwd_button').attr('disabled') == "disabled") {
		return;
	}
	$('#save_pwd_button').val('Please wait...');
    $("#save_pwd_button").attr("disabled", true);
	var old_pwd = $('#old_pwd').val();
	var new_pwd = $('#new_pwd').val();
	var rep_pwd = $('#rep_pwd').val();
	$.ajax({
		url:  base_url+"api.php",
		type: "POST",
		data: "act=process_save_password&old_pwd="+old_pwd+"&new_pwd="+new_pwd+"&rep_pwd="+rep_pwd,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				swal("Success!", obj.mes, "success");
			}
			$('#save_pwd_button').val('Save password');
			$("#save_pwd_button").attr("disabled", false);
		},
		timeout: 10000
	});
}

function process_enable_2fa() {
	var get_2fa_code = $('#enable_2fa_code').val();
	var get_user_pwd = $('#enable_2fa_pwd').val();
	$.ajax({
		url:  base_url+"api.php",
		type: "POST",
		data: "act=process_enable_2fa&get_2fa_code="+get_2fa_code+"&get_user_pwd="+get_user_pwd,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				window.location.reload();
				//swal("Success!", obj.mes, "success");
			}
		},
		timeout: 3000
	});
}

function process_disable_2fa() {
	var get_2fa_code = $('#disable_2fa_code').val();
	var get_user_pwd = $('#disable_2fa_pwd').val();
	$.ajax({
		url:  base_url+"api.php",
		type: "POST",
		data: "act=process_disable_2fa&get_2fa_code="+get_2fa_code+"&get_user_pwd="+get_user_pwd,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				window.location.reload();
				//swal("Success!", obj.mes, "success");
			}
		},
		timeout: 3000
	});
}

function process_send_message() {
	var your_email = $('#your_email').val();
	var your_name = $('#your_name').val();
	var subject = $('#subject').val();
	var message = $('#message').val();
	$.ajax({
		url:  base_url+"api.php",
		type: "POST",
		data: "act=process_send_message&email="+your_email+"&name="+your_name+"&subject="+subject+"&message="+message,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				swal("Success!", obj.mes, "success");
			}
		},
		timeout: 3000
	});
}

function process_save_settings() {
	var pay_notis = $('#pay_notis').is(":checked");
	var dep_notis = $('#dep_notis').is(":checked");
	var pwd_notis = $('#pwd_notis').is(":checked");
	var pro_notis = $('#pro_notis').is(":checked");
	$.ajax({
		url:  base_url+"api.php",
		type: "POST",
		data: "act=process_save_settings&pay_notis="+pay_notis+"&dep_notis="+dep_notis+"&pwd_notis="+pwd_notis+"&pro_notis="+pro_notis,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(out){
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				swal("Success!", obj.mes, "success");
			}
		},
		timeout: 3000
	});
}

function process_withdrawal() {
	if($('#process_withdrawal').attr('disabled') == "disabled") {
		return;
	}
    var amount = document.getElementById("withdrawal_amount").value,
		address = document.getElementById("wallet_address").value,
		withdrawal_option = document.getElementById("withdrawal_option").value,
		withdrawal_2fa_code = document.getElementById("withdrawal_2fa_code").value;
    $('#process_withdrawal').html('Please wait...');
    $("#process_withdrawal").attr("disabled", true);
    setTimeout(function() {
        $.ajax({
            type: "POST",
            url: base_url+"api.php",
            data: "act=process_withdrawal&amount=" + amount+"&address="+address+"&withdrawal_option="+withdrawal_option
        }).done(function(out) {
			obj = JSON.parse(out);
			if(obj.ret == 0) {
				swal("Error!", obj.mes, "error");
			} else {
				var current_balance = parseFloat($('.top_balance').text()) * 100000000;
				//$('#your_balance').text(parseFloat((current_balance - amount * 100000000) / 100000000).toFixed(8));
				$('.top_balance').text(parseFloat((current_balance - amount * 100000000) / 100000000).toFixed(8)+' BTC');
				load_withdrawal_history();
				swal("Success!", obj.mes, "success");
			}
			$('#process_withdrawal').html('Withdraw');
            $("#process_withdrawal").attr("disabled", false);
        })
    }, 500);
}
function load_captcha() {
	var captcha_image = document.getElementById("captcha_img"); 
	var captcha_audio = document.getElementById("captcha_audio");
	var captcha_audio_src = document.getElementById("captcha_audio_src");
	captcha_image.setAttribute("src", base_url+"show_captcha.png");
	captcha_audio.pause();
    captcha_audio.load();
	captcha_audio_src.setAttribute("src", base_url+"play_captcha_audio.wav");
}
function play_captcha_audio() {
	var captcha_audio = document.getElementById("captcha_audio"); 
	captcha_audio.play();
}


function load_deposit_history(page_id = 1) {
	$.ajax({
		url: base_url+"load.php",
		type: "POST",
		data: "act=load_deposit_history&page_id="+page_id,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(obj){
			if(obj != '') {
				var deposit_data = JSON.parse(obj);
				var str = "";
				for(i = 0; i < deposit_data.length; i++) {
					if(deposit_data[i].status == 'Completed') {
						status = "<a href='https://www.blockchain.com/btc/tx/"+deposit_data[i].proof+"' style='color: #4caf50'>Completed</a>";
					} else if(deposit_data[i].status == 'Processing'){
						status = "<a href='https://www.blockchain.com/btc/tx/"+deposit_data[i].proof+"' style='color: #03a9f4'>Processing</a>";
					}
					str += 	'<tr class="history_row">'+
				    '<th width="15%">'+deposit_data[i].completion_time+'</th><th width="15%">'+deposit_data[i].amount+'</th><th width="50%"><a href="https://www.blockchain.com/btc/tx/'+deposit_data[i].proof+'">'+deposit_data[i].proof+'</a></th><th width="20%">'+status+'</th>'+
					'</tr>';
				}
				$('#show_deposit_history').html(str);
			}
		},
		timeout: 3000
	});
}

function load_withdrawal_history(page_id = 1) {
	$.ajax({
		url: base_url+"load.php",
		type: "POST",
		data: "act=load_withdrawal_history&page_id="+page_id,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(obj){
			if(obj != '') {
				var withdrawal_data = JSON.parse(obj);
				var str = "";
				for(i = 0; i < withdrawal_data.length; i++) {
					var action = "";
					var status = "";
					if(withdrawal_data[i].status == 'Completed') {
						status = "<a href='https://www.blockchain.com/btc/tx/"+withdrawal_data[i].proof+"' style='color: #4caf50'>Completed</a>";
					} else if(withdrawal_data[i].status == 'Processing'){
						status = "<span style='color: #03a9f4'>Processing</span>";
					} else if(withdrawal_data[i].status == 'Canceled'){
						status = "<span style='color: #AAA'>Canceled</span>";
					} else if(withdrawal_data[i].status == 'Pending'){
						status = "<span style='color: #333'>Pending</span>";
					} else if(withdrawal_data[i].status == 'Unconfirmed'){
						status = "<span style='color: #FF5722'>Unconfirmed</span>";
						action = " | <a href='javascript:void(0)' onclick='process_cancel_withdrawal2("+withdrawal_data[i].request_id+")'>Cancel</a>";
					}
					str += 	'<tr class="history_row">'+
								'<th>'+withdrawal_data[i].completion_time+'</th><th>'+withdrawal_data[i].amount+'</th><th><a href="https://www.blockchain.com/btc/address/'+withdrawal_data[i].wallet_address+'">'+withdrawal_data[i].wallet_address+'</a></th><th>'+status+action+'</th>'+
								'</tr>';
				}
				$('#show_withdrawal_history').html(str);
			}
		},
		timeout: 3000
	});
}

function load_wagering_leaderboard(page_id = 1) {
	$.ajax({
		url: base_url+"load.php",
		type: "POST",
		data: "act=load_wagering_leaderboard&page_id="+page_id,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(obj){
			if(obj != '') {
				var leaderboard_data = JSON.parse(obj);
				var str = "";
				for(i = 0; i < leaderboard_data.length; i++) {
					str += 	'<tr class="history_row"><td>'+(i+1)+'</td><td>'+leaderboard_data[i].user_id+'</td><td>'+leaderboard_data[i].total_wagered+'</td><td>'+leaderboard_data[i].reward+'</td></tr>';
				}
				$('#load_wagering_leaderboard tbody').html(str);
			}
		},
		timeout: 3000
	});
}

function load_referral_leaderboard(page_id = 1) {
	$.ajax({
		url: base_url+"load.php",
		type: "POST",
		data: "act=load_referral_leaderboard&page_id="+page_id,
		error: function(){
			console.log("Request timed out. Please try again!");
		},
		success: function(obj){
			if(obj != '') {
				var leaderboard_data = JSON.parse(obj);
				var str = "";
				for(i = 0; i < leaderboard_data.length; i++) {
					str += 	'<tr class="history_row"><td>'+(i+1)+'</td><td>'+leaderboard_data[i].user_id+'</td><td>'+leaderboard_data[i].total_wagered+'</td><td>'+leaderboard_data[i].reward+'</td></tr>';
				}
				$('#load_referral_leaderboard tbody').html(str);
			}
		},
		timeout: 3000
	});
}

function show_countdown_clock(next_rolling_time) {
	var clock;
	if(next_rolling_time > 0) {
		$('#show_countdown_clock').show();
		$('#show_free_rolling_game').hide();
		clock = new FlipClock($('.clock'), next_rolling_time, {
			clockFace: 'MinuteCounter',
			autoStart: true,
			countdown: true,
			callbacks: {
				stop: function() {
					$('#show_free_rolling_game').show();
					$('#show_countdown_clock').hide();
				}
			}
		});
	} else {
		$('#show_free_rolling_game').show();
		$('#show_countdown_clock').hide();
	}
}

function show_contests_countdown_clock(remaining_time) {
	var clock = new FlipClock($('#contests_countdown .clock'), remaining_time, {
		clockFace: 'DailyCounter',
		autoStart: true,
		countdown: true,
		showSeconds: false,
		callbacks: {
			stop: function() {
				
			}
		}
	});
}


function show_2fa_qrcode() {
	var secret_code = $('#secret_code').val();
	var user_id = $('#user_id').val();
	var qrcode = new QRCode(document.getElementById("qrcode"), {
		width : 200,
		height : 200
	});
	qrcode.makeCode("otpauth://totp/"+user_id+"@bitpick.io?secret="+secret_code
	);
}

function show_deposit_qrcode() {
	var addr = $('#show_deposit_qrcode').attr('depaddr');
	var qrcode = new QRCode(document.getElementById("show_deposit_qrcode"), {
		width : 200,
		height : 200
	});
	qrcode.makeCode(addr);
}

function show_deposit_history_by_page() {
	var page_id = $('#show_deposit_history_pages').val();
	load_deposit_history(page_id);
}

function show_withdrawal_history_by_page() {
	var page_id = $('#show_withdrawal_history_pages').val();
	load_withdrawal_history(page_id);
}

function copy_deposit_address() {
	if($("#deposit_address").val() != 'Could not get the deposit address!') {
		$("#deposit_address").select();
		$('#deposit_address').attr('title', 'copied');
		var copyText = document.getElementById("deposit_address");
		copyText.select();
		document.execCommand("copy");
	}
}

		
$( document ).ready(function() {
	$("#login_button").on("click", process_login);
	$("#continue_login_button").on("click", process_continue_login);
	$("#signup_button").on("click", process_signup);
	$("#continue_recover_button").on("click", process_recover);
	$("#create_new_pwd_button").on("click", process_change_password);
	$("#verify_email_button").on("click", process_verify_email);
	$("#confirm_withdrawal_button").on("click", process_confirm_withdrawal);
	$("#cancel_withdrawal_button").on("click", process_cancel_withdrawal);
	$("#roll_button").on("click", process_roll);
	$(".dismiss_noti_button").on("click", process_dismiss_noti);
	$(".snd_veri_email_button").on("click", process_snd_veri_email);
	$("#save_withdrawal_adrr_button").on("click", process_save_withdrawal_adrr);
	$("#process_withdrawal").on("click", process_withdrawal);
	$("#save_pwd_button").on("click", process_save_password);
	$("#enable_2fa_button").on("click", process_enable_2fa);
	$("#disable_2fa_button").on("click", process_disable_2fa);
	$("#send_message_button").on("click", process_send_message);
	$("#save_settings_button").on("click", process_save_settings);
	$("#load_captcha").on("click", load_captcha);
	$("#play_captcha_audio").on("click", play_captcha_audio);
	$("#show_deposit_history_pages").on("change", show_deposit_history_by_page);
	$("#show_withdrawal_history_pages").on("change", show_withdrawal_history_by_page);
	$("#deposit_address").on("focus", copy_deposit_address);
	$("#load_wagering_leaderboard select").on("change", function() {load_wagering_leaderboard($(this).val())});
	$("#load_referral_leaderboard select").on("change", function() {load_referral_leaderboard($(this).val())});
	if($('#enable_2fa').length) {show_2fa_qrcode();}
	if($('#show_deposit_qrcode').length) {show_deposit_qrcode();}
	var url = document.location.toString();
	if (url.match('#')) {
		$('.nav-tabs a[href="#' + url.split('#')[1] + '"]').tab('show');
	}
});






